<?php
/**
 * Hotel Settings for Archive
 *
 * @package Mytravel/ACF/Settings/HotelDetails
 */

acf_add_local_field_group(
	array(
		'key'                   => 'group_60b79c2cdebf7',
		'title'                 => 'Hotel Details',
		'fields'                => array(
			array(
				'key'               => 'field_60b9d6d273485',
				'label'             => 'General',
				'name'              => '',
				'type'              => 'tab',
				'instructions'      => '',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'placement'         => 'left',
				'endpoint'          => 0,
			),
			array(
				'key'               => 'field_60bd822573525',
				'label'             => 'Layout',
				'name'              => 'layout',
				'type'              => 'select',
				'instructions'      => '',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'choices'           => array(
					'v1' => 'v1',
					'v2' => 'v2',
					'v3' => 'v3',
				),
				'default_value'     => 'v1',
				'allow_null'        => 0,
				'multiple'          => 0,
				'ui'                => 0,
				'return_format'     => 'value',
				'ajax'              => 0,
				'placeholder'       => '',
			),
			array(
				'key'               => 'field_60c76ec887b7f',
				'label'             => 'Badges',
				'name'              => '',
				'type'              => 'tab',
				'instructions'      => '',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'placement'         => 'left',
				'endpoint'          => 0,
			),
			array(
				'key'               => 'field_60c76ee987b80',
				'label'             => 'List View Top',
				'name'              => 'list_view_top_badge',
				'type'              => 'taxonomy',
				'instructions'      => 'Displayed above title in list view',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'taxonomy'          => 'product_tag',
				'field_type'        => 'select',
				'allow_null'        => 0,
				'add_term'          => 1,
				'save_terms'        => 0,
				'load_terms'        => 0,
				'return_format'     => 'object',
				'multiple'          => 0,
			),
			array(
				'key'               => 'field_60c7828dc2fb6',
				'label'             => 'List View Below Title',
				'name'              => 'list_view_badges',
				'type'              => 'taxonomy',
				'instructions'      => 'Displayed below title in list view',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'taxonomy'          => 'product_tag',
				'field_type'        => 'checkbox',
				'add_term'          => 1,
				'save_terms'        => 0,
				'load_terms'        => 0,
				'return_format'     => 'object',
				'multiple'          => 0,
				'allow_null'        => 0,
			),
			array(
				'key'               => 'field_60c76f2145edc',
				'label'             => 'Sidebar/List View Bottom',
				'name'              => 'sidebar_badge',
				'type'              => 'group',
				'instructions'      => 'This badge is displayed in Single Hotel Sidebar as well as in List View Bottom',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'layout'            => 'row',
				'sub_fields'        => array(
					array(
						'key'               => 'field_60c76f3145edd',
						'label'             => 'Field',
						'name'              => 'sidebar_badge_field',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => '',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'maxlength'         => '',
					),
					array(
						'key'               => 'field_60c76f4245ede',
						'label'             => 'Value',
						'name'              => 'sidebar_badge_value',
						'type'              => 'taxonomy',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => '',
							'id'    => '',
						),
						'taxonomy'          => 'product_tag',
						'field_type'        => 'select',
						'allow_null'        => 0,
						'add_term'          => 1,
						'save_terms'        => 0,
						'load_terms'        => 0,
						'return_format'     => 'object',
						'multiple'          => 0,
					),
				),
			),
			array(
				'key'               => 'field_60c789cb11615',
				'label'             => 'Single Hotel Page Above Title',
				'name'              => 'single_hotel_above_title_badges',
				'type'              => 'taxonomy',
				'instructions'      => 'Badges displayed above title in single hotel page',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'taxonomy'          => 'product_tag',
				'field_type'        => 'multi_select',
				'allow_null'        => 0,
				'add_term'          => 1,
				'save_terms'        => 0,
				'load_terms'        => 0,
				'return_format'     => 'object',
				'multiple'          => 0,
			),
			array(
				'key'               => 'field_60b9b83e5d53c',
				'label'             => 'Location',
				'name'              => '',
				'type'              => 'tab',
				'instructions'      => '',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'placement'         => 'left',
				'endpoint'          => 0,
			),
			array(
				'key'               => 'field_60ba4d99535bf',
				'label'             => 'Location Rating',
				'name'              => 'location_rating',
				'type'              => 'range',
				'instructions'      => 'Set location rating should reflect how far the property is from popular landmarks, city center and essentials like public transport, airports, convenience store, etc.',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'default_value'     => '3.7',
				'min'               => 1,
				'max'               => 5,
				'step'              => '0.1',
				'prepend'           => '',
				'append'            => '',
			),
			array(
				'key'               => 'field_60bdab2eac0f3',
				'label'             => 'Location Tags',
				'name'              => 'location_tags',
				'type'              => 'taxonomy',
				'instructions'      => '',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'taxonomy'          => 'pa_location-tags',
				'field_type'        => 'checkbox',
				'add_term'          => 1,
				'save_terms'        => 0,
				'load_terms'        => 0,
				'return_format'     => 'object',
				'multiple'          => 0,
				'allow_null'        => 0,
			),
			array(
				'key'               => 'field_60b9b8acf5138',
				'label'             => 'Display Location',
				'name'              => 'display_location',
				'type'              => 'text',
				'instructions'      => 'Location information that you want to display in the Hotels list and Single page. Please note that this is for display purpose only and is not used in filters. Use Attributes for filtering purposes.',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'default_value'     => '',
				'placeholder'       => '',
				'prepend'           => '',
				'append'            => '',
				'maxlength'         => '',
			),
			array(
				'key'               => 'field_60ba4c49e4792',
				'label'             => 'Location Map',
				'name'              => 'location_map',
				'type'              => 'google_map',
				'instructions'      => '',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'center_lat'        => '',
				'center_lng'        => '',
				'zoom'              => '',
				'height'            => '',
			),
			array(
				'key'               => 'field_60bcddc3c6a1e',
				'label'             => 'Nearest Essentials',
				'name'              => 'nearest_essentials',
				'type'              => 'group',
				'instructions'      => 'Enter each essential in a separate line. Separate the essential name & distance by a |',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'layout'            => 'row',
				'sub_fields'        => array(
					array(
						'key'               => 'field_60bcde10c6a1f',
						'label'             => 'Airports',
						'name'              => 'nearest_airports',
						'type'              => 'textarea',
						'instructions'      => 'Set custom attributes for the wrapper element. Each attribute in a separate line. Separate attribute key from the value using | character.',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => '',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => 'London City Airport (LCY)|1.2 km|6 minutes',
						'maxlength'         => '',
						'rows'              => 3,
						'new_lines'         => '',
					),
					array(
						'key'               => 'field_60bcdebec6a20',
						'label'             => 'Public transportation',
						'name'              => 'nearest_public_transportation',
						'type'              => 'textarea',
						'instructions'      => 'Set custom attributes for the wrapper element. Each attribute in a separate line. Separate attribute key from the value using | character.',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => '',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => 'DLR - Prince Regent Metro Station|250 m|7 mins',
						'maxlength'         => '',
						'rows'              => 3,
						'new_lines'         => '',
					),
					array(
						'key'               => 'field_60bce063c6a21',
						'label'             => 'Hospital or clinic',
						'name'              => 'nearest_hospital_or_clinic',
						'type'              => 'textarea',
						'instructions'      => 'Set custom attributes for the wrapper element. Each attribute in a separate line. Separate attribute key from the value using | character.',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => '',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => 'West Beckton Health Centre|1 km',
						'maxlength'         => '',
						'rows'              => 3,
						'new_lines'         => '',
					),
					array(
						'key'               => 'field_60bce063c6a22',
						'label'             => 'Horsepower (hp)',
						'name'              => 'nearest_horsepower',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => '',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => '200',
						'maxlength'         => '',
						'new_lines'         => '',
					),
					array(
						'key'               => 'field_60bce063c6a23',
						'label'             => 'Transmission',
						'name'              => 'nearest_transmission',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => '',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => 'Manual',
						'maxlength'         => '',
						'new_lines'         => '',
					),
					array(
						'key'               => 'field_60bce063c6a24',
						'label'             => 'Condition',
						'name'              => 'nearest_condition',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => '',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => 'New',
						'maxlength'         => '',
						'new_lines'         => '',
					),
					array(
						'key'               => 'field_60bce063c6a25',
						'label'             => 'Drive',
						'name'              => 'nearest_drive',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => '',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => 'Rear',
						'maxlength'         => '',
						'new_lines'         => '',
					),
					array(
						'key'               => 'field_60bce063c6a26',
						'label'             => 'Warranty',
						'name'              => 'nearest_warranty',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => '',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => 'Yes',
						'maxlength'         => '',
						'new_lines'         => '',
					),
					array(
						'key'               => 'field_60bce063c6a27',
						'label'             => 'Hospital or clinic',
						'name'              => 'nearest_hospital_or_clinic_1',
						'type'              => 'textarea',
						'instructions'      => 'Set custom attributes for the wrapper element. Each attribute in a separate line. Separate attribute key from the value using | character.',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => '',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => 'West Beckton Health Centre|1 km',
						'maxlength'         => '',
						'rows'              => 3,
						'new_lines'         => '',
					),
					array(
						'key'               => 'field_60bce063c6a28',
						'label'             => 'Airports',
						'name'              => 'nearest_airports_1',
						'type'              => 'textarea',
						'instructions'      => 'Set custom attributes for the wrapper element. Each attribute in a separate line. Separate attribute key from the value using | character.',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => '',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => 'London City Airport (LCY)|1.2 km|6 minutes',
						'maxlength'         => '',
						'rows'              => 3,
						'new_lines'         => '',
					),
					array(
						'key'               => 'field_60bce063c6a29',
						'label'             => 'Public transportation',
						'name'              => 'nearest_public_transportation_1',
						'type'              => 'textarea',
						'instructions'      => 'Set custom attributes for the wrapper element. Each attribute in a separate line. Separate attribute key from the value using | character.',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => '',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => 'DLR - Prince Regent Metro Station|250 m|7 mins',
						'maxlength'         => '',
						'rows'              => 3,
						'new_lines'         => '',
					),
					array(
						'key'               => 'field_60bce063c6a30',
						'label'             => 'Shopping',
						'name'              => 'nearest_shopping',
						'type'              => 'textarea',
						'instructions'      => 'Set custom attributes for the wrapper element. Each attribute in a separate line. Separate attribute key from the value using | character.',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => '',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => 'Harrods|1.5 km',
						'maxlength'         => '',
						'rows'              => 3,
						'new_lines'         => '',
					),
				),
			),
			array(
				'key'               => 'field_60bce1aae9355',
				'label'             => 'Landmarks',
				'name'              => 'landmarks',
				'type'              => 'group',
				'instructions'      => 'Enter each landmark in a separate line.',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'layout'            => 'row',
				'sub_fields'        => array(
					array(
						'key'               => 'field_60bce1b5e9356',
						'label'             => 'Popular Landmarks',
						'name'              => 'popular_landmarks',
						'type'              => 'textarea',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => '',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => '',
						'maxlength'         => '',
						'rows'              => 5,
						'new_lines'         => '',
					),
					array(
						'key'               => 'field_60bce1cae9357',
						'label'             => 'Nearby Landmarks',
						'name'              => 'nearby_landmarks',
						'type'              => 'textarea',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => '',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => '',
						'maxlength'         => '',
						'rows'              => 5,
						'new_lines'         => '',
					),
					array(
						'key'               => 'field_60bce1b5e9358',
						'label'             => 'Popular Landmarks',
						'name'              => 'popular_landmarks_1',
						'type'              => 'textarea',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => '',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => '',
						'maxlength'         => '',
						'rows'              => 5,
						'new_lines'         => '',
					),
					array(
						'key'               => 'field_60bce1cae9359',
						'label'             => 'Nearby Landmarks',
						'name'              => 'nearby_landmarks_1',
						'type'              => 'textarea',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => '',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => '',
						'maxlength'         => '',
						'rows'              => 5,
						'new_lines'         => '',
					),
				),
			),
			array(
				'key'               => 'field_60ba7e364cab6',
				'label'             => 'Amenities',
				'name'              => '',
				'type'              => 'tab',
				'instructions'      => '',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'placement'         => 'left',
				'endpoint'          => 0,
			),
			array(
				'key'               => 'field_60ba7e434cab7',
				'label'             => 'Amenities',
				'name'              => 'amenities',
				'type'              => 'taxonomy',
				'instructions'      => 'Select the amenities available at the property.',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'taxonomy'          => 'pa_property-facilities',
				'field_type'        => 'checkbox',
				'add_term'          => 1,
				'save_terms'        => 0,
				'load_terms'        => 0,
				'return_format'     => 'object',
				'multiple'          => 0,
				'allow_null'        => 0,
			),
			array(
				'key'               => 'field_60bd7f742a75c',
				'label'             => 'Guest Policy',
				'name'              => '',
				'type'              => 'tab',
				'instructions'      => '',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'placement'         => 'top',
				'endpoint'          => 0,
			),
			array(
				'key'               => 'field_60bd816ce0e90',
				'label'             => 'Check-in/Check-out',
				'name'              => 'checkinout',
				'type'              => 'group',
				'instructions'      => '',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'layout'            => 'row',
				'sub_fields'        => array(
					array(
						'key'               => 'field_60bd818ae0e91',
						'label'             => 'Check-in from',
						'name'              => 'check_in_from',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => '',
							'id'    => '',
						),
						'default_value'     => '',
						'append'            => '',
						'placeholder'       => '',
						'prepend'           => '',
						'maxlength'         => '',
					),
					array(
						'key'               => 'field_60bd81aee0e92',
						'label'             => 'Check-out until',
						'name'              => 'check_out_until',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => '',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'maxlength'         => '',
					),
					array(
						'key'               => 'field_60bd81bfe0e93',
						'label'             => 'Reception open until',
						'name'              => 'reception_open_until',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => '',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'maxlength'         => '',
					),
				),
			),
			array(
				'key'               => 'field_60bd7f802a75d',
				'label'             => 'Children Policy',
				'name'              => 'children_policy',
				'type'              => 'textarea',
				'instructions'      => '',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'default_value'     => '',
				'placeholder'       => '',
				'maxlength'         => '',
				'rows'              => 3,
				'new_lines'         => '',
			),
			array(
				'key'               => 'field_60bd808a2a75f',
				'label'             => 'Extra Beds',
				'name'              => 'extra_beds',
				'type'              => 'wysiwyg',
				'instructions'      => '',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'default_value'     => '',
				'tabs'              => 'all',
				'toolbar'           => 'full',
				'media_upload'      => 0,
				'delay'             => 0,
			),
			array(
				'key'               => 'field_60bd83f9bfbfa',
				'label'             => 'Others',
				'name'              => 'others',
				'type'              => 'wysiwyg',
				'instructions'      => '',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'default_value'     => '',
				'tabs'              => 'all',
				'toolbar'           => 'full',
				'media_upload'      => 0,
				'delay'             => 0,
			),
			array(
				'key'               => 'field_60bd828c1307f',
				'label'             => 'Facts',
				'name'              => '',
				'type'              => 'tab',
				'instructions'      => '',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'placement'         => 'left',
				'endpoint'          => 0,
			),
			array(
				'key'               => 'field_60bd82a113080',
				'label'             => 'Getting around',
				'name'              => 'getting_around',
				'type'              => 'group',
				'instructions'      => '',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'layout'            => 'row',
				'sub_fields'        => array(
					array(
						'key'               => 'field_60bd82bb13081',
						'label'             => 'Distance from city center',
						'name'              => 'distance_from_city_center',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => '',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'maxlength'         => '',
					),
					array(
						'key'               => 'field_60bd82cb13082',
						'label'             => 'Travel time to airport',
						'name'              => 'travel_time_to_airport',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => '',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'maxlength'         => '',
					),
				),
			),
			array(
				'key'               => 'field_60bd82ec13084',
				'label'             => 'The Property',
				'name'              => 'the_property',
				'type'              => 'group',
				'instructions'      => '',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'layout'            => 'row',
				'sub_fields'        => array(
					array(
						'key'               => 'field_60bd830613085',
						'label'             => 'Non-smoking rooms/floors',
						'name'              => 'non_smoking_rooms_floors',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => '',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'maxlength'         => '',
					),
					array(
						'key'               => 'field_60bd831913086',
						'label'             => 'Number of floors',
						'name'              => 'number_of_floors',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => '',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'maxlength'         => '',
					),
					array(
						'key'               => 'field_60bd832613087',
						'label'             => 'Number of restaurants',
						'name'              => 'number_of_restaurants',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => '',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'maxlength'         => '',
					),
					array(
						'key'               => 'field_60bd833513088',
						'label'             => 'Number of rooms',
						'name'              => 'number_of_rooms',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => '',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'maxlength'         => '',
					),
					array(
						'key'               => 'field_60bd834213089',
						'label'             => 'Room voltage',
						'name'              => 'room_voltage',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => '',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'maxlength'         => '',
					),
					array(
						'key'               => 'field_60bd83571308a',
						'label'             => 'Most recent renovation',
						'name'              => 'most_recent_renovation',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => '',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'maxlength'         => '',
					),
				),
			),
			array(
				'key'               => 'field_60bd836f1308b',
				'label'             => 'Extras',
				'name'              => 'extras',
				'type'              => 'group',
				'instructions'      => '',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'layout'            => 'row',
				'sub_fields'        => array(
					array(
						'key'               => 'field_60bd83781308c',
						'label'             => 'Breakfast charge',
						'name'              => 'breakfast_charge',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => '',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'maxlength'         => '',
					),
				),
			),
			array(
				'key'               => 'field_61b1a5d196341',
				'label'             => 'Gold Star Rating',
				'name'              => 'gold_star_rating',
				'type'              => 'range',
				'instructions'      => '',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'default_value'     => 3,
				'min'               => 1,
				'max'               => 5,
				'step'              => '0.5',
				'prepend'           => '',
				'append'            => 'star',
			),
		),
		'location'              => array(
			array(
				array(
					'param'    => 'post_type',
					'operator' => '==',
					'value'    => 'product',
				),
				array(
					'param'    => 'post_taxonomy',
					'operator' => '==',
					'value'    => 'product_format:product-format-hotel',
				),
			),
		),
		'menu_order'            => 0,
		'position'              => 'normal',
		'style'                 => 'default',
		'label_placement'       => 'top',
		'instruction_placement' => 'label',
		'hide_on_screen'        => '',
		'active'                => true,
		'description'           => '',
		'show_in_rest'          => 0,
	)
);

