<?php

/**
*
* Bookings functions.
* @version 3.3.0
*
**/

defined( 'ABSPATH' ) || exit;

/**
*
* Get (filtered) bookings.
* @param array - $filters
* @return array
*
**/
function wceb_query_bookings( $filters = array() ) {

    $order_bookings = wceb_get_order_bookings( $filters );
    return apply_filters( 'easy_booking_query_bookings', $order_bookings, $filters );

}

/**
*
* Get bookings product IDs.
* @return array
*
**/
function wceb_get_bookings_product_ids() {

    $product_ids = wceb_get_order_bookings_product_ids();
    return apply_filters( 'easy_booking_booked_product_ids', array_unique( $product_ids ) );
    
}